const urlm = require('url');

// returns the new url adding pageno to the query.
function addPagenoToUrl(req, pageno) {
    const url = new urlm.URL(req.protocol + "://" + req.get('host') + req.url);
    url.searchParams.set("pageno", pageno);
    return url.href;
}

const max_pages_bottom_bar = 4;
let half = Math.floor(max_pages_bottom_bar/2);

function getPageNumbers(totalPages, currentPage){
    let numbers = [];

    if (totalPages < max_pages_bottom_bar){
        for (let num=1; num<=totalPages; num++) numbers.push(num);
        return numbers;
    }

    if (currentPage - half < 1){
        let num = 1;
        while (numbers.length < max_pages_bottom_bar){
            numbers.push(num);
            num++;
        }
    } else if (currentPage + half > totalPages - 1){
        let num = totalPages - (max_pages_bottom_bar - 1);
        while (numbers.length < max_pages_bottom_bar){
            numbers.push(num);
            num++;
        }
    } else {
        let num = currentPage - half + (max_pages_bottom_bar % 2 == 0 ? 1 : 0);
        while (numbers.length < max_pages_bottom_bar){
            numbers.push(num);
            num++;
        }
    }

    return numbers;
}

// Helper function used to paginate.
// Return the HTML links used to paginate.
exports.paginate = (totalItems, itemsPerPage, currentPage, req) => {

    if (totalItems <= itemsPerPage) { return false; }
    const total = Math.ceil(totalItems / itemsPerPage);

    let html = '';
    let pagNumbers = getPageNumbers(total, currentPage);
    html += '<nav id="pagNav">';

    if (currentPage > 1) {
        url = addPagenoToUrl(req, 1);
        html += '<a href="' + url + '">&lt&lt</a>';
        url = addPagenoToUrl(req, currentPage - 1);
        html += '<a href="' + url + '">&lt</a>';
    } else {
        url = addPagenoToUrl(req, 1);
        html += '<a href="' + url + '" class="notClickable">&lt&lt</a>';
        url = addPagenoToUrl(req, currentPage - 1);
        html += '<a href="' + url + '" class="notClickable">&lt</a>';
    }
    for (let pag of pagNumbers){
        url = addPagenoToUrl(req, pag);
        if (pag == currentPage){
            html += '<a href="' + url + '" class="currentPage">' + pag + '</a>';
        } else {
            html += '<a href="' + url + '"> ' + pag + '</a>';
        }
    }
    if (currentPage < total) {
        url = addPagenoToUrl(req, currentPage + 1);
        html += '<a href="' + url + '">&gt</a>';
        url = addPagenoToUrl(req, total);
        html += '<a href="' + url + '">&gt&gt</a>';
    } else {
        url = addPagenoToUrl(req, currentPage + 1);
        html += '<a href="' + url + '" class="notClickable">&gt</a>';
        url = addPagenoToUrl(req, total);
        html += '<a href="' + url + '" class="notClickable">&gt&gt</a>';
    }

    html += '</nav>';
    return html;
};