
'use strict';

module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable(
        'Attachments',
        {
          id: {
            type: Sequelize.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
            unique: true
          },
          mime: {
            type: Sequelize.STRING,
          },
          url: {
            type: Sequelize.STRING
          },
          img: {
            type: Sequelize.BLOB('long')
          },
          createdAt: {
            type: Sequelize.DATE,
            allowNull: false
          },
          updatedAt: {
            type: Sequelize.DATE,
            allowNull: false
          }
        },
        {
          sync: {force: true}
        }
    );
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('Attachments');
  }
};