'use strict';

module.exports = {
    up: async (queryInterface, Sequelize) => {
        await queryInterface.createTable('Users',
            {
                id: {
                    type: Sequelize.INTEGER,
                    allowNull: false,
                    primaryKey: true,
                    autoIncrement: true,
                    unique: true
                },
                profileImgId: {
                    type: Sequelize.INTEGER,
                    references: {
                        model: "Users",
                        key: "id"
                    },
                    onUpdate: 'CASCADE',
                    onDelete: 'SET NULL'
                },
                username: {
                    type: Sequelize.STRING,
                    unique: true,
                    validate: {
                        notEmpty: { msg: "Username must not be empty." }
                    }
                },
                email: {
                    type: Sequelize.STRING,
                    unique: true,
                    validate: {
                        isEmail: { msg: "Username must not be empty." }
                    }
                },
                password: {
                    type: Sequelize.STRING,
                    validate: { notEmpty: { msg: "Password must not be empty." } }
                },
                salt: {
                    type: Sequelize.STRING
                },
                dateOfBirth: {
                    type: Sequelize.DATE
                },
                isAdmin: {
                    type: Sequelize.BOOLEAN,
                    defaultValue: false
                },
                createdAt: {
                    type: Sequelize.DATE,
                    allowNull: false
                },
                updatedAt: {
                    type: Sequelize.DATE,
                    allowNull: false
                }
            },
            {
                sync: { force: true }
            }
        );
    },

    down: async (queryInterface, Sequelize) => {
        await queryInterface.dropTable('Users');
    }
};
