const Sequelize = require('sequelize');

const url = process.env.DATABASE_URL || "sqlite:blog.sqlite";

const sequelize = new Sequelize(url);

const Post = require('./post')(sequelize, Sequelize.DataTypes);
const Attachment = require('./attachment')(sequelize, Sequelize.DataTypes);
const User = require('./user')(sequelize, Sequelize.DataTypes);
const ProfileImg = require('./profileImg')(sequelize, Sequelize.DataTypes);

Attachment.hasOne(Post, { as: 'post', foreignKey: 'attachmentId' });
Post.belongsTo(Attachment, { as: 'attachment', foreignKey: 'attachmentId' });

User.hasOne(Post, { as: 'post', foreignKey: 'userId' });
Post.belongsTo(User, { as: 'user', foreignKey: 'userId' });

ProfileImg.hasOne(User, { as: 'user', foreignKey: 'profileImgId' });
User.belongsTo(ProfileImg, { as: 'profileImg', foreignKey: 'profileImgId' });

module.exports = sequelize;