'use strict';

const {Model} = require('sequelize');

// Definition of the Post model:
module.exports = (sequelize, DataTypes) => {

    class Post extends Model {
    }

    Post.init({
            title: {
                type: DataTypes.STRING,
                validate: {notEmpty: {msg: "Ttile must not be empty"}}
            },
            body: {
                type: DataTypes.STRING,
                validate: {notEmpty: {msg: "Body must not be empty"}}
            },
            userId: {
                type: DataTypes.INTEGER,
                validate: {notEmpty: {msg: "userId must not be empty"}}
            }
        }, {
            sequelize
        }
    );

    return Post;
};