var express = require('express');
var router = express.Router();

const multer = require('multer');
const storage = multer.memoryStorage();
const upload = multer({
  storage: storage,
  limits: {fileSize: 20 * 1024 * 1024}});


/* Home page. */
router.get('/', function(req, res, next) {
  res.render('index');
});


/* Author page. */
router.get('/author', function(req, res, next) {
  res.render('author');
});


/* Post pages. */
const postController = require('../controllers/post');
router.param('postId', postController.load);

router.get('/posts',                            postController.index);
router.get('/posts/:postId(\\d+)',              postController.show);
router.get('/posts/new',                        postController.new);
router.post('/posts',                           upload.single('image'),
                                                postController.create);
router.get('/posts/:postId(\\d+)/edit',         postController.edit);
router.put('/posts/:postId(\\d+)',              upload.single('image'),
                                                postController.update);
router.delete('/posts/:postId(\\d+)',           postController.destroy);
router.get('/posts/:postId(\\d+)/attachment',   postController.attachment);


/* User pages. */
const userController = require('../controllers/user');
router.param('userId', userController.load);

router.get('/users',                          userController.index);
router.get('/users/:userId(\\d+)',            userController.show);
router.get('/users/new',                      userController.new);
router.post('/users',                         upload.single('image'),
                                              userController.create);
router.get('/users/:userId(\\d+)/edit',       userController.edit);
router.put('/users/:userId(\\d+)',            upload.single('image'),
                                              userController.update);
router.delete('/users/:userId(\\d+)',         userController.destroy);
router.get('/users/:userId(\\d+)/profileImg', userController.profileImg);


/* Login & Autologout */
const sessionController = require('../controllers/session');

router.get('/login',      sessionController.new);
router.post('/login',     sessionController.create);
router.delete('/login',   sessionController.destroy);
router.all('*',           sessionController.deleteExpiredUserSession);


module.exports = router;
